unit mSudoku;

interface
uses Sysutils;
const stoppZahl=81; // spaeter 81
type
  tZiffMenge = set of 0..9;  // Menge vorkommender Ziffern
type TSudoku = class
  private
    merkZeile, merkSpalte, merkKasten : array[0..8] of tZiffMenge;
    F : array[0..80] of integer;
    function kastenNr (j : integer) : integer;
    procedure testen(n, test : integer; var fertig:boolean);
    procedure loesen(n : integer; var fertig:boolean);
    procedure AllesMerken;
  public
    constructor create;
    procedure Loese;
    procedure ZahlSchreiben (wohin: integer; was : string);
    function ZahlLesen (welche : integer) : integer;
end;

implementation

constructor TSudoku.create;
var i : integer;
begin
  for i := 0 to 80 do F[i] :=0;
end;

procedure TSudoku.Loese;
var fertig : boolean;
begin
  AllesMerken;
  fertig := false;
  loesen(0,fertig);
end;

procedure TSudoku.AllesMerken;
var i : integer;
begin
  for i := 0 to 8 do begin
   merkZeile[i] := [];
   merkSpalte[i] := [];
   merkKasten[i] := [];
 end;
 for i := 0 to 80 do
   if F[i] > 0 then begin
     merkZeile[i div 9] := merkZeile[i div 9] + [F[i]];
     merkSpalte[i mod 9] := merkSpalte[i mod 9] + [F[i]];
     merkKasten[kastenNr(i)] := merkKasten[kastenNr(i)] + [F[i]];
   end;
end;

procedure TSudoku.loesen(n : integer; var fertig: boolean);
var geloest : boolean; testzahl : integer;
begin
  if n<stoppzahl then begin
    if F[n] > 0 then loesen(n+1, fertig) // vorgegebene Zahl --> weiter
    else begin
      testzahl := 1;
      while (not fertig) and (testzahl <= 9) do begin // alle probieren

        testen (n, testzahl, fertig);
        inc(testzahl,1);
      end;
    end;
  end else fertig := true;
end;

procedure TSudoku.testen(n, test : integer; var fertig: boolean);
var geloest : boolean; t : integer;
begin
  geloest := false; t := test;
  if (t>0) and (t<10) and
     (not (test in merkZeile[n div 9])) and
     (not (test in merkSpalte[n mod 9])) and
     not (test in merkKasten[kastenNr(n)])
  then begin                   // setzen
     merkZeile[n div 9] := merkZeile[n div 9] + [test];
     merkSpalte[n mod 9] := merkSpalte[n mod 9] + [test];
     merkKasten[kastenNr(n)] := merkKasten[kastenNr(n)] + [test];
     F[n] := test;
     loesen(n+1, geloest);   // rekursiver Aufruf
     if not geloest then begin // Backtracking zurueck
        merkZeile[n div 9] := merkZeile[n div 9] - [test];
        merkSpalte[n mod 9] := merkSpalte[n mod 9] - [test];
        merkKasten[kastenNr(n)] := merkKasten[kastenNr(n)] - [test];
        F[n] := 0;
     end;
  end;
  fertig := geloest;
end;

function TSudoku.kastenNr (j : integer) : integer;
begin
  kastenNr := 3 * (j div 27) + (j div 3) mod 3
end;

procedure TSudoku.ZahlSchreiben (wohin: integer; was : string);
begin F[wohin] := strToInt(was); end;

function TSudoku.ZahlLesen (welche : integer) : integer;
begin  ZahlLesen := F[welche] end;

end.
 